<?php
/**
 * Pro Designs and Plugins Feed
 *
 * @package Blog Designer - Post and Widget
 * @since 1.4
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Action to add menu
add_action('admin_menu', 'bdpw_register_design_page');

/**
 * Register plugin design page in admin menu
 * 
 * @package Blog Designer - Post and Widget
 * @since 1.0.0
 */
function bdpw_register_design_page() {
	add_menu_page( __('Blog Designer', 'blog-designer-for-post-and-widget'), __('Blog Designer', 'blog-designer-for-post-and-widget'), 'manage_options', 'bdpw-about',  'bdpw_settings_page', 'dashicons-sticky', 6 );
}

/**
 * Function to display plugin design HTML
 * 
 * @package Blog Designer - Post and Widget
 * @since 1.0.0
 */
function bdpw_settings_page() {

	$wpos_feed_tabs = bdpw_help_tabs();
	$active_tab 	= isset($_GET['tab']) ? $_GET['tab'] : 'how-it-work';
?>

	<div class="wrap bdpw-wrap">

		<h2 class="nav-tab-wrapper">
			<?php
			foreach ($wpos_feed_tabs as $tab_key => $tab_val) {
				$tab_name	= $tab_val['name'];
				$active_cls = ($tab_key == $active_tab) ? 'nav-tab-active' : '';
				$tab_link 	= add_query_arg( array('page' => 'bdpw-about', 'tab' => $tab_key), admin_url('admin.php') );
			?>

			<a class="nav-tab <?php echo $active_cls; ?>" href="<?php echo $tab_link; ?>"><?php echo $tab_name; ?></a>

			<?php } ?>
		</h2>

		<div class="bdpw-tab-cnt-wrp">
		<?php
			if( isset($active_tab) && $active_tab == 'how-it-work' ) {
				bdpw_howitwork_page();
			}
			else if( isset($active_tab) && $active_tab == 'plugins-feed' ) {
				echo  bdpw_get_plugin_design( 'plugins-feed' );
			} else {
				echo  bdpw_get_plugin_design( 'offers-feed' );
			}
		?>
		</div><!-- end .bdpw-tab-cnt-wrp -->

	</div><!-- end .bdpw-wrap -->

<?php
}

/**
 * Gets the plugin design part feed
 *
 * @package Blog Designer - Post and Widget
 * @since 1.0.0
 */
function bdpw_get_plugin_design( $feed_type = '' ) {

	$active_tab = isset($_GET['tab']) ? $_GET['tab'] : '';

	// If tab is not set then return
	if( empty($active_tab) ) {
		return false;
	}

	// Taking some variables
	$wpos_feed_tabs =  bdpw_help_tabs();
	$transient_key 	= isset($wpos_feed_tabs[$active_tab]['transient_key']) 	? $wpos_feed_tabs[$active_tab]['transient_key'] 	: 'bdpw_' . $active_tab;
	$url 			= isset($wpos_feed_tabs[$active_tab]['url']) 			? $wpos_feed_tabs[$active_tab]['url'] 				: '';
	$transient_time = isset($wpos_feed_tabs[$active_tab]['transient_time']) ? $wpos_feed_tabs[$active_tab]['transient_time'] 	: 172800;
	$cache 			= get_transient( $transient_key );

	if ( false === $cache ) {

		$feed 			= wp_remote_get( esc_url_raw( $url ), array( 'timeout' => 120, 'sslverify' => false ) );
		$response_code 	= wp_remote_retrieve_response_code( $feed );

		if ( ! is_wp_error( $feed ) && $response_code == 200 ) {
			if ( isset( $feed['body'] ) && strlen( $feed['body'] ) > 0 ) {
				$cache = wp_remote_retrieve_body( $feed );
				set_transient( $transient_key, $cache, $transient_time );
			}
		} else {
			$cache = '<div class="error"><p>' . __( 'There was an error retrieving the data from the server. Please try again later.', 'blog-designer-for-post-and-widget' ) . '</div>';
		}
	}
	return $cache;
}

/**
 * Function to get plugin feed tabs
 *
 *@package Blog Designer - Post and Widget
 * @since 1.0.0
 */
function bdpw_help_tabs() {
	$wpos_feed_tabs = array(
						'how-it-work' 	=> array(
													'name' => __('How It Works', 'blog-designer-for-post-and-widget'),
												),
						'plugins-feed' 	=> array(
													'name' 				=> __('Our Plugins', 'blog-designer-for-post-and-widget'),
													'url'				=> 'http://wponlinesupport.com/plugin-data-api/plugins-data.php',
													'transient_key'		=> 'wpos_plugins_feed',
													'transient_time'	=> 172800
												)
					);
	return $wpos_feed_tabs;
}

/**
 * Function to get 'How It Works' HTML
 *
 * @package Blog Designer - Post and Widget
 * @package Blog Designer - Post and Widget
 * @package Blog Designer - Post and Widget
 * @since 1.0.0
 */
function bdpw_howitwork_page() { ?>

	<style type="text/css">
		.wpos-pro-box .hndle{background-color:#0073AA; color:#fff;}
		.wpos-pro-box.postbox{background:#dbf0fa none repeat scroll 0 0; border:1px solid #0073aa; color:#191e23;}
		.postbox-container .wpos-list li:before{font-family: dashicons; content: "\f139"; font-size:20px; color: #0073aa; vertical-align: middle;}
		.bdpw-wrap .wpos-button-full{display:block; text-align:center; box-shadow:none; border-radius:0;}
		.bdpw-shortcode-preview{background-color: #e7e7e7; font-weight: bold; padding: 2px 5px; display: inline-block; margin:0 0 2px 0;}
		.upgrade-to-pro{font-size:18px; text-align:center; margin-bottom:15px;}
	</style>

	<div id="poststuff">
		<div id="post-body" class="metabox-holder columns-2">
			<!--How it workd HTML -->
			<div id="post-body-content">
				<div class="meta-box-sortables">
					<div class="postbox">

						<h3 class="hndle">
							<span><?php _e( 'How It Works - Display and Shortcode', 'blog-designer-for-post-and-widget' ); ?></span>
						</h3>

						<div class="inside">
							<table class="form-table">
								<tbody>
									<tr>
										<th>
											<label><?php _e('Getting Started', 'blog-designer-for-post-and-widget'); ?></label>
										</th>
										<td>
											<ul>
												<li><?php _e('Step-1. Go to "Post --> Add New".', 'blog-designer-for-post-and-widget'); ?></li>
												<li><?php _e('Step-2. Add post title, description and images', 'blog-designer-for-post-and-widget'); ?></li>
												<li><?php _e('Step-3. Select Category and Tags', 'blog-designer-for-post-and-widget'); ?></li>
												
											</ul>
										</td>
									</tr>

									<tr>
										<th>
											<label><?php _e('How Shortcode Works', 'blog-designer-for-post-and-widget'); ?></label>
										</th>
										<td>
											<ul>
												<li><?php _e('Step-1. Create a page like Blog', 'blog-designer-for-post-and-widget'); ?></li>
												<li><?php _e('Step-2. Put below shortcode as per your need.', 'blog-designer-for-post-and-widget'); ?></li>
											</ul>
										</td>
									</tr>

									<tr>
										<th>
											<label><?php _e('All Shortcodes', 'blog-designer-for-post-and-widget'); ?></label>
										</th>
										<td>
											<span class="bdpw-shortcode-preview">[wpspw_post]</span> – <?php _e('Blog Grid Shortcode', 'blog-designer-for-post-and-widget'); ?> <br />
											<span class="bdpw-shortcode-preview">[wpspw_recent_post_slider]</span> – <?php _e('Recent Post Slider Shortcode', 'blog-designer-for-post-and-widget'); ?><br/>
										</td>
									</tr>

									<tr>
										<th>
											<label><?php _e('Need Support?', 'blog-designer-for-post-and-widget'); ?></label>
										</th>
										<td>
											<p><?php _e('Check plugin document for shortcode parameters and demo for designs.', 'blog-designer-for-post-and-widget'); ?></p> <br/>
											<a class="button button-primary" href="https://docs.wponlinesupport.com/blog-designer-post-and-widget/" target="_blank"><?php _e('Documentation', 'blog-designer-for-post-and-widget'); ?></a>
											<a class="button button-primary" href="https://demo.wponlinesupport.com/blog-designer-post-and-widget/" target="_blank"><?php _e('Demo for Designs', 'blog-designer-for-post-and-widget'); ?></a>
										</td>
									</tr>
								</tbody>
							</table>
						</div><!-- .inside -->
					</div><!-- #general -->
				</div><!-- .meta-box-sortables -->
			</div><!-- #post-body-content -->

			<!--Upgrad to Pro HTML -->
			<div id="postbox-container-1" class="postbox-container">
				<div class="meta-box-sortables">
					<div class="postbox wpos-pro-box">

						<h3 class="hndle">
							<span><?php _e( 'Upgrate to Pro', 'blog-designer-for-post-and-widget' ); ?></span>
						</h3>
						<div class="inside">
							<ul class="wpos-list">
								<li><?php _e( '130+ stunning and cool layouts.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '8 Shortcodes.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '50 Designs for Blog Post Grid.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '45 Designs for Blog Post Slider/Carousel.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '24 Designs for Blog Post Masonry Layout.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '8 Designs for Blog Post List View.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '13 Designs for Blog Post Grid Box.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '8 Designs for Blog Post Grid Box Slider.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '5 types of Widgets (Grid, slider and list etc).', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Gutenberg Block Support.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Template overriding feature support.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Visual Composer/WPBakery Page Builder Supports.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Custom Read More link for Blog Post.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Blog display with categories.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Drag & Drop feature to display Blog post in your desired order and other 6 types of order parameter.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Two type Pagination with Next – Previous or Numeric type support with grid layout.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( 'Slider RTL support.', 'blog-designer-for-post-and-widget' ); ?></li>
								<li><?php _e( '100% Multilanguage.', 'blog-designer-for-post-and-widget' ); ?></li>
							</ul>
							<div class="upgrade-to-pro"><?php _e( 'Gain access to <strong>Blog Designer - Post and Widget Pro</strong> included in <br /><strong>Essential Plugin Bundle', 'blog-designer-for-post-and-widget'); ?></div>
							<a class="button button-primary wpos-button-full" href="https://www.wponlinesupport.com/wp-plugin/blog-designer-post-and-widget/?ref=WposPratik&utm_source=WP&utm_medium=Blog-Designer&utm_campaign=Upgrade-PRO" target="_blank"><?php _e('Go Premium ', 'blog-designer-for-post-and-widget'); ?></a>
							<p><a class="button button-primary wpos-button-full" href="https://demo.wponlinesupport.com/prodemo/blog-designer-post-and-widget/" target="_blank"><?php _e('View PRO Demo ', 'blog-designer-for-post-and-widget'); ?></a></p>
						</div><!-- .inside -->
					</div><!-- #general -->

					<div class="postbox">
							<h3 class="hndle">
								<span><?php _e( 'Help to improve this plugin!', 'blog-designer-for-post-and-widget' ); ?></span>
							</h3>
							<div class="inside">
								<p><?php _e('Enjoyed this plugin? You can help by rate this plugin', 'blog-designer-for-post-and-widget'); ?> <a href="https://wordpress.org/support/plugin/blog-designer-for-post-and-widget/reviews/#new-post" target="_blank"><?php _e('5 stars!', 'blog-designer-for-post-and-widget'); ?></a></p>
							</div><!-- .inside -->
					</div><!-- #general -->

				</div><!-- .metabox-holder -->
			</div><!-- #post-container-1 -->

		</div><!-- #post-body -->
	</div><!-- #poststuff -->
<?php }